import numpy as np
from numpy.testing import assert_allclose

from bigym.action_modes import (
    JointPositionActionMode,
)
from bigym.robots import TOLERANCE_ANGULAR, TOLERANCE_LINEAR, RobotFloatingBase
from bigym.envs.reach_target import ReachTarget

from bigym.bigym_env import BiGymEnv


def test_join_position_absolute_block_until_reached():
    env: BiGymEnv = ReachTarget(
        action_mode=JointPositionActionMode(
            floating_base=True, absolute=True, block_until_reached=True, wrist_dof=True
        )
    )
    env.reset()
    base_absolute_target = np.zeros(3)
    for _ in range(100):
        ctrl = np.zeros_like(env.action_space.sample())
        # Control floating base in delta-position action mode
        ctrl[0:2] = np.random.uniform(*RobotFloatingBase.DELTA_RANGE_POS)
        ctrl[2] = np.random.uniform(*RobotFloatingBase.DELTA_RANGE_ROT)
        base_absolute_target += ctrl[0:3]
        # Controlling other joints in absolute mode
        ctrl[3:8] = np.radians(np.random.uniform([0, 0, 0, 0, 0], [30, 30, 30, 30, 30]))
        ctrl[8:13] = np.radians(
            np.random.uniform([0, 0, 0, 0, 0], [30, -30, -30, 30, 30])
        )
        env.step(ctrl)
        qpos = env.robot.qpos_actuated
        # Validate floating base pose
        assert_allclose(qpos[:2], base_absolute_target[:2], atol=TOLERANCE_LINEAR)
        assert_allclose(qpos[2], base_absolute_target[2], atol=TOLERANCE_ANGULAR)
        # Validate other joints
        assert_allclose(qpos[3:], ctrl[3:], atol=TOLERANCE_ANGULAR)
